/*
 * Decompiled with CFR 0.152.
 */
package swingpuzzlegui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import swingpuzzlegui.DNF;
import swingpuzzlegui.Tuple;

class Grid {
    public HashMap<Tuple<Integer, Integer>, Integer> cells = new HashMap();
    public ArrayList<Tuple<Integer, Integer>> errors = new ArrayList();
    public int width = 0;
    public int height = 0;
    int false_color;
    int true_color;
    int unknown_color;
    int invalid_color;
    int matched_color;
    public boolean matched = false;

    public Grid(File gridFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(gridFile));
        int y = 0;
        while (br.ready()) {
            String line = br.readLine();
            int x = 0;
            String[] stringArray = line.split("");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String numStr = stringArray[n2];
                int num = Integer.valueOf(numStr);
                Tuple<Integer, Integer> coord = new Tuple<Integer, Integer>(x, y);
                this.cells.put(coord, num);
                if (this.width < ++x) {
                    this.width = x;
                }
                ++n2;
            }
            if (this.height >= ++y) continue;
            this.height = y;
        }
        br.close();
    }

    public void save(File gridFile) throws FileNotFoundException {
        PrintWriter pr = new PrintWriter(gridFile);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                Tuple<Integer, Integer> coord = new Tuple<Integer, Integer>(x, y);
                String num = this.cells.get(coord).toString();
                pr.print(num);
                ++x;
            }
            pr.println();
            ++y;
        }
        pr.close();
    }

    public Grid(Grid source) {
        this.cells = new HashMap<Tuple<Integer, Integer>, Integer>(source.cells);
        this.errors = new ArrayList<Tuple<Integer, Integer>>(source.errors);
        this.width = source.width;
        this.height = source.height;
    }

    public Grid(DNF dnf) {
        int y_portion = 1;
        int i = 0;
        while (i < dnf.variables.size() / 2) {
            y_portion *= 2;
            ++i;
        }
        this.width = dnf.all_true % y_portion + 1;
        this.height = dnf.all_true / y_portion + 1;
        i = 0;
        while (i <= dnf.all_true) {
            int x = i % y_portion;
            int y = i / y_portion;
            Tuple<Integer, Integer> coord = new Tuple<Integer, Integer>(x, y);
            dnf.set_vars(i);
            int c = dnf.eval() ? 1 : 0;
            this.cells.put(coord, c);
            ++i;
        }
    }

    public void random_flip(int count) {
        ArrayList<Tuple<Integer, Integer>> flips = new ArrayList<Tuple<Integer, Integer>>(this.cells.keySet());
        Collections.shuffle(flips);
        int i = 0;
        for (Tuple<Integer, Integer> coord : flips) {
            if (i == count) break;
            int c = this.cells.get(coord);
            if (c >= 2) continue;
            c = (c + 1) % 2;
            this.cells.put(coord, c);
            this.errors.add(coord);
            ++i;
        }
    }

    public void random_unknown(int count) {
        ArrayList<Tuple<Integer, Integer>> unknowns = new ArrayList<Tuple<Integer, Integer>>(this.cells.keySet());
        Collections.shuffle(unknowns);
        int i = 0;
        for (Tuple<Integer, Integer> coord : unknowns) {
            if (i == count) break;
            int c = this.cells.get(coord);
            if (c >= 2) continue;
            c = 2;
            this.cells.put(coord, c);
            this.errors.add(coord);
            ++i;
        }
    }

    public void all_unknown() {
        for (Tuple<Integer, Integer> coord : this.cells.keySet()) {
            this.cells.put(coord, 2);
        }
    }

    public void sample_grid(Grid source) {
        Random rand = new Random();
        ArrayList<Tuple<Integer, Integer>> samples = new ArrayList<Tuple<Integer, Integer>>(source.cells.keySet());
        Collections.shuffle(samples);
        Tuple<Integer, Integer> coord = samples.get(0);
        int c = source.cells.get(coord);
        if (rand.nextDouble() < 0.001) {
            c = (c + 1) % 2;
        }
        this.cells.put(coord, c);
    }

    public void click_flip(int c_x, int c_y) {
        Tuple<Integer, Integer> coord = new Tuple<Integer, Integer>(c_x, c_y);
        int c = this.cells.get(coord);
        c = (c + 1) % 2;
        this.cells.put(coord, c);
    }

    public int diff_count(Grid obj_grid) {
        int mismatched = 0;
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                int c1;
                Tuple<Integer, Integer> coord = new Tuple<Integer, Integer>(x, y);
                int c0 = this.cells.get(coord);
                if (c0 != (c1 = obj_grid.cells.get(coord).intValue())) {
                    ++mismatched;
                }
                ++y;
            }
            ++x;
        }
        return mismatched;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Grid)) {
            return false;
        }
        Grid obj_grid = (Grid)obj;
        int mismatched = this.diff_count(obj_grid);
        return mismatched <= 0;
    }
}

